'Beispiel: VB .Net - Fensterbeschreibung aller offenen Fenster ermitteln - 2
'
Option Explicit On
Option Strict On

Imports System.Runtime.InteropServices

Public Class Form1

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
            Handles Button1.Click
        Dim TList As New List(Of String)(GetVisibleWindows.ReturnWindowTitle)
        If TList.Count > 0 Then
            For Each items As String In TList
                Me.ListBox1.Items.Add(items)
            Next
        Else
            Me.ListBox1.Items.Add("No appWind opened...")
        End If
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) _
            Handles MyBase.Load
        CenterToScreen()
    End Sub

End Class

Public Class GetVisibleWindows

#Region "Win32 Api"

    <DllImport("user32.dll")> _
       Private Shared Function IsWindowVisible(ByVal hWnd As IntPtr) As Boolean
    End Function

#End Region

#Region "Functions"

    Public Shared ReadOnly Property ReturnWindowTitle() As List(Of String)
        Get
            Return EnumOpenedWindowTitle()
        End Get
    End Property

    Private Shared Function EnumOpenedWindowTitle() As List(Of String)
        Dim TList As New List(Of String)
        For Each hProcess As Process In Process.GetProcesses
            With hProcess
                If IsWindowVisible(.MainWindowHandle) AndAlso .MainWindowTitle <> String.Empty Then
                    TList.Add(hProcess.MainWindowTitle)
                End If
            End With
        Next
        If TList.Count > 0 Then
            Return TList
        End If
        Return Nothing
    End Function

#End Region

End Class
